

* Retraitement ERFS 1984

/* Note : 
Pour le moment, retraitmeent uniquement des bases au niveau foyer et mnage
Il semble qu'il existe des sous-bases correspondant aux cases de la dclaration.
Voir si CASD fournit ces bases. Cela permettrait d'affinier revenus pro + revenus financiers
*/
*forval x=1/2 {
global year=1984
use "$datarev/rev$year/char.dta",clear
gen idindiv=idmen+iddecl
tempfile temp
save "`temp'",replace
use "$datarev/rev$year/decl.dta",clear
gen idindiv=idmen+iddecl
merge 1:1 idindiv using "`temp'"

gen year=$year




* Ponderation redresse au niveau du menage
	* Memo: prf: pondrationr edress foyer, pb= ponderation brute demo; pond inverse du taux de sondage
	gen pondn=prf
	drop if pondn==0
	

* Caractristiques dmographiques
	* age
		gen age=real(agdcf)
		replace age=1984-1000-real(anddgi) if age==.
	* age du conjoint
		gen agec=real(agdef)
		replace agec=1984-1000-real(ancdgi) if agec==. & ancdgi~="999"
	* Retraitement age
		replace age =agec if (agec~=. & age==.) | (agec>=20 & agec~=. & age<20)
		replace agec =age if (agec==. & age~=. & ancdgi~="999") | (agec<20 & age>=20 & age~=.)
		* On vire les foyers de moins de 20 ans ou les clibataires de moins de 20 ans (hors champs)
			drop if age<20 & agec<20
			drop if age<20 
	* Nombre de dclarants dans la dclaration
		gen ndecl=2
		replace ndecl=1 if agec==.
		
	* Structure demographique des pac majeurs
		gen npac=0
		gen anaispac_1=. 
		/* verif
				quiet sum npac
				dis r(max)
				forval a=1/`r(max)' {
					sum anaispac_`a'
				}
			
		*/
		
	
	* situation matrimoniale : 
		* Code: 1= mari (M) ; 2 = clibataire (C), 3: Divorc (D),4: veuf (V), 6:pacs (O)
		* Avant 2002, le pacs n'existait pas
		* Quleques non dclarants
		gen mat="C" if emacf=="1"
		replace mat="M" if emacf=="2"
		replace mat="V" if emacf=="3"
		replace mat="D" if emacf=="4"
	
	
	* Loyer imput residence principale et scondaires
		*gen rfon_owner_irpp_foy=loyhp+ loyrs3+loyrs2 +loyrs1
		
	* Nombre de dclaralts dans le foyer
		
	* sexe du chef de foyer
		gen sexe=real(sexcf)
	* Variables impots pays changent avant 1995
		gen irtot=max(0,zimpof) /* Impot immediat */
		gen irpv=. /* impot pv taux propor */
		gen iravantpv=irtot-irpv

		
***********************************************************
*I)Traitements, salaires, pensions et rentes viagres     *
***********************************************************

foreach var of newlist sal_irpp chom_irpp frais_prof pension_irpp {
		gen `var'=0
		gen `var'_conj=0
		gen `var'_pac=0
	}
	
	* A) Salaires et chmages
	*************************

		* Pas de distinction entre sal et chom : on met tout dans sal et on utilisera seulement salchom
		* Remuneration des associs dissocis des salaires avant 1996. A partir de 1996 tout est report en AJ
		replace sal_irpp=max(0,ytsacf)
		replace chom_irpp=0

		replace sal_irpp_conj =  max(0,ytsaef)
		replace chom_irpp_conj = 0
		
		
	* B) Retraite
	**************
		* Inclue galement pensions alimentaires reues. Plus le cas  partir de 1999.
		* En 1979, inclue galement les rentes viagres
			replace pension_irpp=max(0,ypercf)
			replace pension_irpp_conj=max(0,yperef)
	
	gen rente_irpp_foy=0
			
* E) Au niveau foyer fiscal
	****************************
		gen sal_irpp_foy=sal_irpp+sal_irpp_conj+sal_irpp_pac
		gen chom_irpp_foy=chom_irpp+chom_irpp_conj+chom_irpp_pac
		gen frais_prof_foy=frais_prof+frais_prof_conj+frais_prof_pac
		gen pension_irpp_foy =pension_irpp+ pension_irpp_conj +pension_irpp_pac
		gen salchom_irpp_foy=sal_irpp_foy+ chom_irpp_foy


**************************************	
*II)  Revenus des capitaux mobiliers
**************************************	
		* EN 1979, seulement une variable agrge valeurs mobilires
		* A)Assurance-vie
		******************
			* Assurance-vie non dclare avant 1998
			* Barme
				gen rfin_av_bar_irpp_foy = 0
			* PL
				gen rfin_av_pl_irpp_foy= 0
			* Total
				gen rfin_av_irpp_foy=rfin_av_bar_irpp_foy+rfin_av_pl_irpp_foy
		
		* B)Dividendes : 
		*****************
			* Au barme 
				gen rfin_div_bar_irpp_foy = 0
			* Au PL  partir de 2008
				gen rfin_div_pl_irpp_foy=0
			* Total
				gen rfin_div_irpp_foy=rfin_div_pl_irpp_foy+rfin_div_bar_irpp_foy
		
			
		* C)Intrts 
		**************
			* Barme
				gen rfin_int_bar_irpp_foy= 0
			* PL report seulement  partir de 2002 ou avant 1996
				gen rfin_int_pl_irpp_foy= 0
			* Total
				gen rfin_int_irpp_foy= rfin_int_bar_irpp_foy+ rfin_int_pl_irpp_foy
		* D) Totaux 
		**************
				gen rfin_pl_irpp_foy=0
				gen rfin_bar_irpp_foy=rfin_av_bar_irpp_foy+rfin_div_bar_irpp_foy+rfin_int_bar_irpp_foy
				gen rfin_irpp_foy=max(zvamf,0)
		
		
			
			
*******************************
*III) Revenus non salaris
*******************************
		* En 1979, seulement dcomposition entre BIC, BNC et BA. Les revenus incluent les dficits
		foreach var of newlist nonsal_irpp nonsalexo_irpp nonsal defnonsal_irpp microbic_vente microbic_serv microbnc {
		gen `var'=0
		gen `var'_conj=0
		gen `var'_pac=0
	}
	
	replace nonsal_irpp=max(0,yacccf)+max(0,ybagcf)+max(0,ybiccf)+max(0,ybnccf)+max(0,yrgacf)
	replace nonsal_irpp_conj=max(0,yaccef)+max(0,ybagef)+max(0,ybicef)+max(0,ybncef)+max(0,yrgaef)
	gen nonsal_irpp_foy=nonsal_irpp+nonsal_irpp_conj+nonsal_irpp_pac
	gen nonsalexo_irpp_foy=nonsalexo_irpp+nonsalexo_irpp_conj+nonsalexo_irpp_pac
	gen nonsal_foy=nonsal_irpp_foy+nonsalexo_irpp_foy	
	replace nonsal=nonsal_irpp+nonsalexo_irpp
	
	
************************			
*IV)  Revenus fonciers
************************

		* A)Regime normal net de charges et intrts
		********************************************
			*en cas de benefices
				gen rfon_normal_irpp_foy=max(0,zfouf)+max(0,zforf)
			* en cas de deficits: deficts catgoriels ou global
				gen rfon_defcat_foy= 0
				gen rfon_defglo_foy=0
				
		* B) Regime micro-foncier brut
		******************************
			*Cr en 1997
			gen rfon_micro_irpp_foy=0
		
		gen rfon_irpp_foy=rfon_normal_irpp_foy+rfon_micro_irpp_foy
		* Note il existe aussi loyrpm : loyer ou valeur locative de l'habitation

*****************
* V) Plus value		
******************
		* Non disponible dans l'enquete
		gen rfin_pv_pro_irpp_foy=0
		gen rfin_mv_pro_irpp_foy=0
		gen rfin_pv_fon_irpp_foy=0
		gen rfin_pv_fin_irpp_foy=0
		gen rfin_mv_fin_irpp_foy=0
		gen rfin_pv_options_foy=0
		gen rfin_pv_irpp_foy=rfin_pv_fin_irpp_foy+rfin_pv_fon_irpp_foy+rfin_pv_pro_irpp_foy+rfin_pv_options_foy
		gen rfin_mv_irpp_foy=rfin_mv_fin_irpp_foy+rfin_mv_pro_irpp_foy		

********************************************************************************************
* VI) Correction de l'ge manquant : seule information valable retrait ou non via pension_irpp
***********************************************************************************************
	set seed 1946896
	gen retire=0
	replace retire=1 if pension_irpp_foy>0
	gen prob =1 if age==.
	replace age=int(20+runiform()*40) if retire==0 & prob==1
	replace age=int(60+runiform()*20) if retire==1 & prob==1
	drop prob retire
		
***************************************************************************
	expand 10
	replace pondn=pondn/10
	keep year pondn-rfin_mv_irpp_foy
		drop micro* 
		gen idfoy=_n
		#delimit;
			order year idfoy pondn ndecl  age agec sexe mat  npac anaispac* 
			salchom* sal* chom* pens* rente* nonsal* nonsal_irpp* defnonsal_irpp* nonsalexo_irpp* rfon* 
			rfin_irpp_foy rfin_bar_irpp_foy rfin_pl_irpp_foy rfin_int_irpp_foy rfin_int_bar_irpp_foy rfin_int_pl_irpp_foy rfin_div_irpp_foy rfin_div_bar_irpp_foy rfin_div_pl_irpp_foy rfin_av_irpp_foy rfin_av_bar_irpp_foy rfin_av_pl_irpp_foy 
			rfin_pv_irpp_foy rfin_pv_pro_irpp_foy rfin_pv_fon_irpp_foy rfin_pv_fin_irpp_foy rfin_pv_options_foy rfin_mv_irpp_foy rfin_mv_pro_irpp_foy  rfin_mv_fin_irpp_foy ;
			 #delimit cr
save "$revdir/ERFS/rev$year.dta",replace	

*if `x'==1 {
* Retraitement du top 10%
	
	* Rev tot et rev trav
		gen reverfs =rfin_irpp_foy+rfon_irpp_foy+nonsal_foy+pension_irpp_foy+salchom_irpp_foy+rente_irpp_foy
		gen trav=pension_irpp_foy+salchom_irpp_foy+rente_irpp_foy
		
	* Groupe de revenus
		sort year 
		gen pondvr=round(100*pondn) 
		bys year : cumul reverfs [w=pondvr], gen (p100)
		gen p10=p100*100
		gen py   = 0
		replace py=90  if p10 >=90 & p10 <95 & py==0
		replace py= 95   if p10 >=95 & p10 <99 & py==0
		replace py= 99   if p10 >=99 & p10 <99.5 & py==0
		replace py= 995   if p10 >=99.5 & p10 <99.9 & py==0
		replace py= 999   if p10 >=99.9 & py==0
		drop p10 p100 pondvr
		
	* Donnes tabulations Piketty
		merge m:1 year py using "$revdir/ERFS/retraitementERFS.dta"
		drop _merge
		keep if year==$year
		
	* Ajustement du revenu total
		bys year py : egen rerfs=sum(reverfs*pondn)
		bys year py : egen tot=sum(pondn)
		replace rerfs=rerfs/tot
		replace reverfs=reverfs*rev/rerfs if py~=0
	
	* Cohrence entre rev tot et ses composantes
		gen temp=rfin_irpp_foy+rfon_irpp_foy+nonsal_foy+trav
		foreach var of varlist rfin_irpp_foy rfon_irpp_foy nonsal_foy trav {
			replace `var'=`var'*reverfs/temp if py~=0 & temp~=0
		}
		drop temp rerfs tot py
		
	* Classement par groupe de revenus
		sort year 
		gen pondvr=round(100*pondn) 
		bys year : cumul reverfs [w=pondvr], gen (p100)
		gen p10=p100*100
		gen py   = 0
		replace py=90  if p10 >=90 & p10 <95 & py==0
		replace py= 95   if p10 >=95 & p10 <99 & py==0
		replace py= 99   if p10 >=99 & p10 <99.5 & py==0
		replace py= 995   if p10 >=99.5 & p10 <99.9 & py==0
		replace py= 999   if p10 >=99.9 & py==0
		drop p10 p100 pondvr
		drop rfon rfi travail rpro rev
		merge m:1 year py using "$revdir/ERFS/retraitementERFS.dta"
		drop _merge
		keep if year==$year
		
	* Ajustement de la composition du revenu du top 10% sur donnes tabulations
			bys year py : egen tot=sum(pondn)
			forval i=1/7 {	
				* Revenu et compo rev par tranche dans erfs
					bys year py : egen rerfs=sum(reverfs*pondn)
					foreach var of varlist rfin_irpp_foy rfon_irpp_foy trav nonsal_foy {
						bys year py : egen `var'erfs=sum(`var'*pondn)
						replace `var'erfs=`var'erfs/rerfs
					}
					replace rerfs=rerfs/tot
					
				* Ajustement de la composition du revenu du top 0.1% sur donnes tabulations
					replace rfin_irpp_foy=rfin_irpp_foy*rfi/rfin_irpp_foyerfs if py~=0
					replace rfon_irpp_foy=rfon_irpp_foy*rfon/rfon_irpp_foyerfs if py~=0
					replace trav=trav*travail/traverfs if py~=0
					replace nonsal_foy=nonsal_foy*rpro/nonsal_foyerfs if py~=0
							
				* Cohrence entre rev tot et ses composantes
					gen temp=rfin_irpp_foy+rfon_irpp_foy+nonsal_foy+trav
					foreach var of varlist rfin_irpp_foy rfon_irpp_foy nonsal_foy trav {
						replace `var'=`var'*reverfs/temp if py~=0
					}
					drop temp rerfs-nonsal_foyerfs

			}	
			drop  tot

	/* verif
	* Revenu et compo rev par tranche dans erfs
		bys year py : egen tot=sum(pondn)
		bys year py : egen rerfs=sum(reverfs*pondn)
		foreach var of varlist rfin_irpp_foy rfon_irpp_foy trav nonsal_foy {
			bys year py : egen `var'erfs2=sum(`var'*pondn)
			replace `var'erfs2=`var'erfs2/rerfs
		}
		replace rerfs=rerfs/tot
		br py rev rerfs rfon rfi travail rpro rfin_irpp_foyerfs2 rfon_irpp_foyerfs2 traverfs2 nonsal_foyerfs2 if py~=py[_n+1]
		drop tot rerfs-nonsal_foyerfs2
		*oki */
			drop rfon-rev

		
	* Ajustement des diffrentes sous-composantes
	
		* revenu du travail
			gen temp=sal_irpp +sal_irpp_conj+ pension_irpp +pension_irpp_conj
			foreach var of varlist sal_irpp sal_irpp_conj pension_irpp pension_irpp_conj {
				replace `var'=`var'*trav/temp if py~=0 & temp~=0
			}
			drop temp trav
			replace sal_irpp_foy=sal_irpp+sal_irpp_conj+sal_irpp_pac
			replace pension_irpp_foy =pension_irpp+ pension_irpp_conj +pension_irpp_pac
			
		* Revenu foncier
			replace rfon_normal_irpp_foy= rfon_irpp_foy
		
		* Revenus pro
			replace nonsal_irpp_foy = nonsal_foy
			gen temp=nonsal_irpp+ nonsal_irpp_conj
			foreach var of varlist nonsal_irpp nonsal_irpp_conj {
				replace `var'=`var'*nonsal_foy/temp if py~=0 & temp~=0
			}
			drop temp reverfs py
		
	 save "$wfrev/rev${year}.dta",replace
/*}

if `x'==2 {
	 save "$wfrev/rev${year}avtretraitement.dta",replace
}
}		
*/		
